function varargout = simpleraft(t,y,flag,k,sv,m,mx)

switch flag
 case ''                      % Return dy/dt = f(t,y).
   varargout{1} = f(t,y,k,sv,m,mx);
 case 'events'                  % Return [value,isterminal,direction]
   [varargout{1:3}] = events(t,y,k,sv,m,mx);
 otherwise
   error(['Unknown flag ''' flag '''.']);
 end
% -------------------------------------------------------------
% 1  I       kd
% 2  M       ki
% 3  R       kp
% 4  SR      kPaddSR
% 5  P       kbetaPSR
% 6  SP      kmaddPSR
% 7  D       kRaddSR
% 8  RSR     kbetaRSR
% 9  PSR     kPaddSP
% 10 PSP     kbetaPSP
% 11         kRaddSP
% 12         ktbasis used for ordinary termination
% 13         ktbI    used for intermediate termination
% -------------------------------------------------------------
function dydt = f(t,y,k,sv,m,mx)

convM =(sv(2)-y(2))/sv(2);  % bereken conversie M
nc = (sv(4)-y(4))+2*(sv(1)-y(1));

t

if convM<1e-8
   convM=1e-8;
end

if nc<1e-8
   nc=1e-8;
end

if sv(4)>0
   length=round(convM*sv(2)/nc);   % radicaallengte=dormantlengte
else
   length=round((y(2)*k(3))/((2*(k(1)*y(1)*6e8)^0.5)+1e-3*y(2)));  % radicaallengte=kinetische lengte
end

if length<3
   length=3;
end

wp=m(1)*convM/(m(1)+m(2)); % bereken wp

Dmon    = 9e-8;
Dshort  = Dmon;
Dlong   = Dmon/(length^min(2, 0.66+2*wp));
Ddouble = Dmon/((2*length)^min(2, 0.66+2*wp));

ktSS  = k(12)*(Dshort+Dshort);
ktISS  = k(13)*(Dshort+Dshort);
% ktLL  = k(12)*(Dlong+Dlong);
ktLS  = k(12)*(Dlong+Dshort);
ktILS  = k(13)*(Dlong+Dshort);
% ktLLL = k(13)*(Ddouble+Dlong);    %intermediate termination PSP P
ktLLS = k(13)*(Ddouble+Dshort);   %intermediate termination PSP R

eff=0.7;
Ithermal=4e-9*y(2)^3;
IT=Ithermal;

 dydt = zeros(10,1);
 dydt(1)=-k(1)*y(1);
 dydt(2)=-k(3)*y(2)*y(5)-k(2)*y(3)*y(2);
 dydt(3)=IT+k(1)*eff*2*y(1)+k(5)*y(9)+k(8)*y(8)-k(7)*y(3)*y(4)-k(11)*y(3)*y(6)-ktLS*y(3)*y(5)-ktLLS*y(3)*y(10)-k(2)*y(3)*y(2)-ktSS*y(3)*y(3)-ktILS*y(3)*y(9)-ktISS*y(3)*y(8);
 dydt(4)=k(6)*y(9)+k(8)*y(8)-k(4)*y(5)*y(4)-k(7)*y(3)*y(4);
 dydt(5)=k(2)*y(3)*y(2)+k(6)*y(9)+k(10)*y(10)-k(4)*y(4)*y(5)-k(9)*y(5)*y(6)-ktLS*y(5)*y(5)-ktLLS*y(5)*y(10)-ktLS*y(3)*y(5)-ktLLS*y(5)*y(9)-ktILS*y(5)*y(8);
 dydt(6)=k(5)*y(9)+k(10)*y(10)-k(9)*y(5)*y(6)-k(11)*y(3)*y(6);
 dydt(7)=ktLS*y(5)*y(5)+ktLS*y(5)*y(3)+ktLLS*y(5)*y(10)+ktLLS*y(3)*y(10)+ktISS*y(3)*y(8)+ktILS*y(5)*y(8)+ktILS*y(3)*y(9);
 dydt(8)=k(7)*y(3)*y(4)-k(8)*y(8)-ktISS*y(3)*y(8)-ktILS*y(5)*y(8);
 dydt(9)=k(4)*y(4)*y(5)+k(11)*y(3)*y(6)-k(5)*y(9)-k(6)*y(9)-ktILS*y(3)*y(9)-ktLLS*y(5)*y(9);
 dydt(10)=k(9)*y(5)*y(6)-k(10)*y(10)-ktLLS*y(5)*y(10)-ktLLS*y(3)*y(10);

 %--------------------------------------------------------------------------------------
 
 function [value,isterminal,direction] = events(t,y,k,sv,m,mx)

 % sv(1)= concentration I at t=0,  sv(2)= concentration M at t=0
 % y(1) = concentration I at t=t,  y(2) = concentration M at t=t
 % mx(1)= maximum conversion of I, mx(2)= maximum conversion of M
 % abort integration when one of both components reaches max. conversion

 value = zeros(1,2);             % max conversion=zero crossing
 % value(1:2) = [((sv(1)-y(1))/sv(1))-mx(1), ((sv(2)-y(2))/sv(2))-mx(2)];
 value(1:2) = [1, ((sv(2)-y(2))/sv(2))-mx(2)];
 
 isterminal = zeros(1,2);
 isterminal(1:2) = [1,1];

 direction = zeros(1,2);         % direction unimportant
% -------------------------------------------------------------
