clear all;

name='noraftterm4';

kd   = 1.35e-4;
ki   = 7e2;
kp   = 6.6e2;

kPaddSR  = 7e6;        %P adds
kPaddSP  = 7e6;

kRaddSP  = 7e6;        %R adds
kRaddSR  = 7e6;

kbetaPSP = 1.2e5;        %P fragments
kmaddPSR = 1.2e5;

kbetaRSR = 1.2e5;        %R fragments
kbetaPSR = 1.2e5;

ktbasis  = 2*pi*0.25*7e-9*6.02e23;
ktbI     = 1.5*pi*0.25*7e-9*6.02e23; %ktbasis; %set zero to eliminate intermediate termination

kmatrix =[kd ki kp kPaddSR kbetaPSR kmaddPSR kRaddSR kbetaRSR kPaddSP kbetaPSP kRaddSP ktbasis ktbI];

maxci = 0.9999;
maxcm = 0.9999;

mx = [maxci maxcm];

mmo=31;
msol=58;
mass=[mmo msol];


I   = 4.4e-3;  %initiator
M   = 3;       %monomer
R   = 0;       %ini- or raft-derived radicals
SR  = 0;    %raft
P   = 0;       %propagating radicals
SP  = 0;       %dormant species
D   = 0;       %dead chains
RSR = 0;       %intermediate
RSP = 0;       %intermediate
PSP = 0;       %intermediate

%------------------------------------------------------------------------------------
y0=[I M R SR P SP D RSR RSP PSP];
tmax=[0 3.5e5];
options = odeset('AbsTol',1e-12,'RelTol',3e-13,'BDF','off','Stats','on','Events','on');
%------------------------------------------------------------------------------------
tic;
[t,x]=ode15s('simpleraft',tmax,y0,options,kmatrix,y0,mass,mx);
toc;
%------------------------------------------------------------------------------------

fpm = fopen('overview.txt','a');

temp=[name '\r\n'];
fprintf(fpm,temp);

temp=['ini \t' num2str(I,'%.3g') '\r\n'];
fprintf(fpm,temp);

temp=['mono \t' num2str(M,'%.3g') '\r\n'];
fprintf(fpm,temp);

temp=['raft \t' num2str(SR,'%.3g') '\r\n'];
fprintf(fpm,temp);

temp=['kd \t' num2str(kd,'%.3g') '\r\n'];
fprintf(fpm,temp);

temp=['ki \t' num2str(ki,'%.3g') '\r\n'];
fprintf(fpm,temp);

temp=['kp \t' num2str(kp,'%.3g') '\r\n'];
fprintf(fpm,temp);

temp=['kRaddSR \t' num2str(kRaddSR,'%.3g') '\r\n'];
fprintf(fpm,temp);

temp=['kRaddSP \t' num2str(kRaddSP,'%.3g') '\r\n'];
fprintf(fpm,temp);

temp=['kPaddSR \t' num2str(kPaddSR,'%.3g') '\r\n'];
fprintf(fpm,temp);

temp=['kPaddSP \t' num2str(kPaddSP,'%.3g') '\r\n'];
fprintf(fpm,temp);

temp=['kbetaRSR \t' num2str(kbetaRSR,'%.3g') '\r\n'];
fprintf(fpm,temp);

temp=['kbetaPSP \t' num2str(kbetaPSP,'%.3g') '\r\n'];
fprintf(fpm,temp);

temp=['kbetaPSR \t' num2str(kbetaPSR,'%.3g') '\r\n'];
fprintf(fpm,temp);

temp=['kmaddPSR \t' num2str(kmaddPSR,'%.3g') '\r\n'];
fprintf(fpm,temp);

temp='\r\n\r\n';
fprintf(fpm,temp);

fclose(fpm);
%------------------------------------------------------------------------------------
nm= [name '.dat']
fm  = fopen(nm,'w');
fprintf(fm,'t mc I M R SR P SP D RSR RSP PSP\n');



for i=1:max(size(t))
   mc=((M-x(i,2))/M)*100;
   fprintf(fm,'%.4e %.4e %.4e %.4e %.4e %.4e %.4e %.4e %.4e %.4e %.4e %.4e\n',t(i),mc,x(i,1),x(i,2),x(i,3),x(i,4),x(i,5),x(i,6),x(i,7),x(i,8),x(i,9),x(i,10));
end % for i

fclose(fm);
%------------------------------------------------------------------------------------
clear all;