 function varargout = raft(t,y,flag,a,b,c,d,e)
 
 switch flag
 case ''                                 % Return dy/dt = f(t,y).
   varargout{1} = f(t,y,a,b,c,d,e);
 case 'init'                             % Return default [tspan,y0,options].
   [varargout{1:3}] = init(a,b,c,d,e);
 case 'events'                           % Return [value,isterminal,direction].
   [varargout{1:3}] = events(t,y,a,b,c,d,e);
 otherwise
   error(['Unknown flag ''' flag '''.']);
 end

% -------------------+---------------+--------------+---------------------------------
% conc. in time      |	k-values     |	conc. t=0   |	max conversions
% -------------------+---------------+--------------+---------------------------------
%	I	y(1)	kd	a(1)	I0	b(1)	max.conv. I	c(1)
%	M	y(2)	kt	a(2)	M0	b(2)	max.conv. M	c(2)
%	T0	y(3)	ktr	a(3)	T0	b(3)	max. long raft	c(3) 
%	Tn	y(3+d)	kp	a(4)
%	P0	y(4+d)	f	a(5)
%	Pn	y(4+2d)
%	D0	y(5+2d)
%	D2n	y(4+4d)
% ------------------------------------------------------------------------------------
%	number of species	d
%       kt matrix		e
%--------------------------------------------------------------------------------------

 function dydt = f(t,y,a,b,c,d,e)

 no = (4*d)+4;
 dydt=zeros(no,1);           % define output column vector
 rad=sum(y((4+d):(4+2*d)))   % total radical concentration
 raft=sum(y(3:(3+d)));       % total raft concentration

 av=0;
 for i = 0:d
    av=av+(y(4+d+i)*i);
 end
 if (rad<=0)
    av=0;
 else
    av=fix(av/rad) %average radical chainlength
 end

 dydt(1) = -a(1)*y(1);       % initiator decay
 dydt(2) = -a(4)*y(2)*rad;   % monomer consumption

 tijd=num2str(t),
 % raft0=num2str(y(3))

 for i = 0:d
   dydt(3+i)= a(3)*y(4+d+i)*raft-a(3)*y(3+i)*rad;
   dydt(4+d+i)=-a(4)*y(4+d+i)*y(2)-a(3)*y(4+d+i)*raft+a(3)*y(3+i)*rad-e((av+1),(i+1))*y(4+d+i)*rad;
 end
 
 dydt(4+d)=dydt(4+d)+(2*a(1)*a(5)*y(1));          % first radical species

 for i = 1:(d)
   dydt(4+d+i)=dydt(4+d+i)+(a(4)*y(2)*y(3+d+i));
 end

 dydt(4+2*d)=dydt(4+2*d)+(a(4)*y(4+2*d)*y(2));    % last radical species ???
 
 for i=0:(d-1)                   % chain length dead material
   for j=0:i                     % loop different combinations to form dead species
      r1=i-j;                    % length radical 1
      r2=j;                      % length radical 2
      dydt(5+(2*d)+i)=dydt(5+(2*d)+i)+0.5*e((r1+1),(r2+1))*y(4+d+r1)*y(4+d+r2);
   end % for j
 end   % for i

  for i=d:(2*(d-1))              % chain length dead material
   for j=fix(i/2):-1:0           % loop different combinations to form dead species
      r1=i-j;                    % length radical 1
      r2=j;                      % length radical 2
      if (r1>(d-1))|(r2>(d-1)),break,end  % non existing radical length
      dydt(5+(2*d)+i)=dydt(5+(2*d)+i)+0.5*e((r1+1),(r2+1))*y(4+d+r1)*y(4+d+r2);
   end % for j
 end   % for i

 dydt(4+4*d)=e(d,d)*y(4+2*d)*y(4+2*d);
 %--------------------------------------------------------------------------------------
 
 function [tspan,y0,options] = init(a,b,c,d,e)

 tspan = [0 1e5];    % default timespan
 nr = (4*d)+5;       % number of differential equations/compounds
 y0 = zeros(1,nr);   % starting concentrations
 y0(1:3) = b(1:3);
 options = odeset('AbsTol',1e-7,'RelTol',1e-7,'BDF','off','Stats','on','Events','on');
                     % error tolerances, Backw. Diff. Formulas 
 
 %--------------------------------------------------------------------------------------
 
 function [value,isterminal,direction] = events(t,y,a,b,c,d,e)

 % b(1)= concentration I at t=0,  b(2)= concentration M at t=0
 % y(1)= concentration I at t=t,  y(2)= concentration M at t=t
 % c(1)= maximum conversion of I, c(2)= maximum conversion of M
 % abort integration when one of both components reaches max. conversion

 % second criterium: integrating noise, [radicals]<0

 % third criterium: heap of non-distinguisable species > 1%

 value = zeros(1,d+4);
 value(1:2) = [((b(1)-y(1))/b(1))-c(1), ((b(2)-y(2))/b(2))-c(2)]; % max conversion=zero crossing
 for i =0:d
    value(i+3) = y(4+d(1)+i);                                     % [radical]<0
 end
 value(1,d+4)= (y(d+3)/b(3))-c(3);                                % third criterium
 isterminal = zeros(1,d+4);
 isterminal(1:2) = [1,1];
 isterminal(d+4) =[1];                                        % all are terminal events
 direction = zeros(1,d+4);                                        % direction unimportant
 % ----------------------------------------------------------------------------------------
 
