clear all;

n = 50;          % number of identifiable species
nr = (4*n)+4;    % number of differential equations

ktr = 6.6e5;     % transfer rate constant
kt = 1e8;        % termination rate constant
kp = 6.6e2;      % propagation rate constant
kd = 1e-4;     % dissociation rate constant
f = 0.90;         % initiator efficiency

T = 7.5e-2;      % initial transfer agent concentration
I = 3e-3;        % initial initiator concentration
M = 3.8;           % initial monomer concentration

maxci=0.999;  % stop integration at this conversion for initiator I
maxcm=0.999;     % stop integration at this conversion for monomer M
maxpc=0.01;      % max fraction of raft chains as undistinguishable species

tmax = 1e5;      % alternate time of integration (specify in ode15s function call)

%-----------------------------------------------------------------------------

kvalue=[kd kt ktr kp f];
conc=[I M T];
maxc=[maxci maxcm maxpc];
y0=zeros(1,nr);
y0(1:3)=conc;

%-----------------------------------------------------------------------------

TERM=zeros((n+1),(n+1));
for i=1:(n+1)
  for j=1:(n+1)
    if (i<=85)
      D1=9e-8/((i+1)^0.5);
    else
      D1=9e-8*(85^0.1)/((i+1)^0.6);
    end    % if i
    if (j<=85)
      D2=9e-8/((j+1)^0.5);
    else
      D2=9e-8*(85^0.1)/((j+1)^0.6);
    end    % if j
    TERM(i,j)=6.6e15*(D1+D2);
%    TERM(i,j)=5.58e13*(D1+D2);
  end %for j
end %for i

%------do calculation-------------------------------------------------------

tic; % timer on
[t,x]=ode15s('raft',[],y0,[],kvalue,conc,maxc,n,TERM);
toc  % display calculation time

%---------open files------------------------------------------------------------

fm = fopen('main.dat','w');
ft = fopen('raft.dat','w');
fp = fopen('rad.dat','w');


%-----create headers----------------------------------------------------------

fst='time mc';
fsp='time mc';

for j = 0:n
   fst=[fst ' t' num2str(j)];
   fsp=[fsp ' p' num2str(j)];
end

fst=[fst ' \n'];
fsp=[fsp ' \n'];

fprintf(fm,'time mc mono ini dead mnR mwR pdR mnD mwD pdD mnt mwt pdt\n');
fprintf(ft,fst);
fprintf(fp,fsp);

%-----------MW averages--raft----------------------------------------------------

r=zeros(max(size(t)),6);
for i=1:max(size(t))
   for j=0:n
      r(i,1)=r(i,1)+x(i,3+j);                                     % SUM N
      r(i,2)=r(i,2)+(x(i,3+j)*(250+(j*104.15)));                  % SUM (N*M)
      r(i,3)=r(i,3)+(x(i,3+j)*(250+(j*104.15))*(250+(j*104.15))); % SUM (N*M^2)
   end
   r(i,4)=r(i,2)/r(i,1);   % number average molar mass   Mn= SUM(N*M)/SUM(N)
   r(i,5)=r(i,3)/r(i,2);   % weight average molar mass   Mw= SUM(N*M^2)/SUM(N*M)
   r(i,6)=r(i,5)/r(i,4);   % polydispersity index        PD= Mw/Mn
end
%------------MW averages--dead----------------------------------------------------
d=zeros(max(size(t)),6);
for i=1:max(size(t))
   for j=0:((2*n)-1)
      d(i,1)=d(i,1)+ x(i,5+(2*n)+j);                                    % SUM N
      d(i,2)=d(i,2)+(x(i,5+(2*n)+j)*(130+(j*104.15)));                  % SUM (N*M)
      d(i,3)=d(i,3)+(x(i,5+(2*n)+j)*(130+(j*104.15))*(130+(j*104.15))); % SUM (N*M^2)
   end
   d(i,4)=d(i,2)/d(i,1);   % number average molar mass   Mn= SUM(N*M)/SUM(N)
   d(i,5)=d(i,3)/d(i,2);   % weight average molar mass   Mw= SUM(N*M^2)/SUM(N*M)
   d(i,6)=d(i,5)/d(i,4);   % polydispersity index        PD= Mw/Mn
end
%------------MW averages--total----------------------------------------------------
tot=zeros(max(size(t)),3);
for i=1:max(size(t))
   tot(i,1)=(r(i,2)+d(i,2))/(r(i,1)+d(i,1)); % number average molar mass   Mn= n1M1+n2M2/n1+n2
   tot(i,2)=(r(i,3)+d(i,3))/(r(i,2)+d(i,2)); 
                                             % weight average molar mass   Mw= SUM(N*M^2)/SUM(N*M)
   tot(i,3)=tot(i,2)/tot(i,1);   % polydispersity index        PD= Mw/Mn
end
%----------output----main--raft--rad---------------------------------------------

for i=1:max(size(t)),
   mc = ((M - x(i,2))/M)*100;
   fprintf(fm,'%.4e %.4e %.4e %.4e %.4e %.4e %.4e %.4e %.4e %.4e %.4e %.4e %.4e %.4e\n',t(i),mc,x(i,2),x(i,1),d(i,1),r(i,4),r(i,5),r(i,6),d(i,4),d(i,5),d(i,6),tot(i,1),tot(i,2),tot(i,3));
   fprintf(ft,'%.4e %.4e',t(i),mc);
   fprintf(fp,'%.4e %.4e',t(i),mc);

   for j = 0:(n-1)
      fprintf(ft,' %.3e',x(i,3+j));   % loop raft species
      fprintf(fp,' %.3e',x(i,4+n+j)); % loop radical species
   end

   fprintf(ft,' %.3e \n',x(i,3+n));   % add final species of each series and add
   fprintf(fp,' %.3e \n',x(i,4+n+n)); % an end-of-line character

end

%------ close files--------------------------------------------------------------

fclose(fm);
fclose(ft);
fclose(fp);

%-----------the-dead-files--------------------------------------------------------

aantal=(2*n)-1;              % aantal dode species
spf=200;                     % aantal species per file
bestand=fix(aantal/spf);     % aantal files (max 200 species per file) minus 1

for i = 0:bestand            % loop door veschillende bestanden (waarde nul is 1 bestand)
   naam=['dead' num2str(i) '.dat'];   %maak filenaam aan
   fd = fopen(naam,'w');             %open file

   if (i<bestand)
      sif=spf;               % sif is aantal bestanden in deze file alleen in de laatste 
   else                      % file is het kleiner dan spf
      sif=aantal-(bestand*spf);
   end  %if

   fsd='time mc';            % header aanmaken
   for j = 0:(sif-1)
      fsd=[fsd ' d' num2str(j+(i*spf))];
   end      % for j
   fsd=[fsd ' \n'];
   fprintf(fd,fsd);

   for k=1:max(size(t)),                 % tijden doorlopen
      mc = ((M - x(k,2))/M)*100;
      fprintf(fd,'%.4e %.4e',t(k),mc);   % conversie & tijd printen

      for j = 0:(sif-2)                  % species doorlopen op 1 na
         temp= x(k,5+(2*n)+j+(i*spf)); 
         if (temp<1e-120)                % prevent ultra-small numbers (unreadable by Origin)
            temp=0;
         end                       % if
         fprintf(fd,' %.3e',temp);       % loop dead species
      end                          %for j

      j=sif-1;                           % laatste species
      temp = x(k,5+(2*n)+j+(i*spf));
      if (temp<1e-120)
        temp=0;
      end                          % if
      fprintf(fd,' %.3e \n',temp);
   end                             % for k

   fclose(fd);
end                                %for i

%-------------------------------------------------------------------------
conv=[1 2 5 10 15 20 25 30 40 50 60 70 80 90 95 96 97 98 99];
nummer=1;
wr=zeros(2,n);             % gewicht raft (1 kolom mw/2 w(m))
wd=zeros(2,(2*n-1));        % gewicht dood (1 kolom mw/2 w(m))

for k=1:max(size(t)),                 % tijden doorlopen
      mc = ((M - x(k,2))/M)*100;

      if (nummer>max(size(conv))),break,end     % alle output files klaar

      if (mc>conv(nummer))
         nummer=nummer + 1;
         
         fn=['r' num2str(conv(nummer-1)) '.dat'];
         fm = fopen(fn,'w');

         for i = 0:(n-1)
            wr(1,(i+1))=(250+(i*104));             % mw as
            wr(2,(i+1))=x(k,3+i)*(250+(i*104));    % gewichts distributie
            fprintf(fm,'%.3e %.3e \n', wr(1,(i+1)), wr(2,(i+1)));
         end % for i

         fclose(fm);
         fn=['d' num2str(conv(nummer-1)) '.dat'];
         fm = fopen(fn,'w');

         for i = 0:(2*n-1)
            wd(1,(i+1))=(130+(i*104));                   % mw as
            wd(2,(i+1))=x(k,5+(2*n)+i)*(130+(i*104));    % gewichts distributie
            fprintf(fm,'%.3e %.3e \n', wd(1,(i+1)), wd(2,(i+1)));
         end % for i

         fclose(fm);

      end % if
end % for k


%clear all;