 function varargout = mymoment(t,y,flag,a,b,c,d)
 
 switch flag
 case ''                                 % Return dy/dt = f(t,y).
   varargout{1} = f(t,y,a,b,c,d);
 case 'init'                             % Return default [tspan,y0,options].
   [varargout{1:3}] = init(a,b,c,d);
 case 'events'                           % Return [value,isterminal,direction].
   [varargout{1:3}] = events(t,y,a,b,c,d);
 otherwise
   error(['Unknown flag ''' flag '''.']);
 end

% -------------------+---------------+--------------+----------------------------
% conc. in time      |	k-values     |	conc. t=0   |	max conversions
% -------------------+---------------+--------------+----------------------------
%	I	y(1) |  kd	a(1) |  I0	b(1)	max.conv. I	c(1)
%	M	y(2) |  kt	a(2) |  M0	b(2)	max.conv. M	c(2)
%	T0	y(3) |  ktr	a(3) |  T0	b(3)	
%	Ti	y(4) |  kp	a(4) |
%	P0	y(5) |  f	a(5) |
%	Pi	y(6) |  kt      a(6) |
%	Di	y(7) |               |
% -------------------+---------------+--------------+----------------------------
% first moment       |second moment  |
%	Pi	y(8) |	Pi	y(9) |	d	number of d.e.'s
%	Ti	y(10)|	Ti	y(11)|
%	Di	y(12)|	Di	y(13)|
%--------------------------------------------------------------------------------

 function dydt = f(t,y,a,b,c,d)
 
 t
 
 no = d;               % number of d.e.s
 dydt=zeros(no,1);     % define output column vector
 %rad=y(5)+y(6)        % total radical concentration
 %raft=y(3)+y(4)       % total raft concentration
% tijd=num2str(t)

%'''''''concentrations''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
dydt(1) = -a(1)*y(1);
dydt(2) = -a(4)*y(2)*(y(5)+y(6));
dydt(3) = a(3)*y(5)*y(4) -a(3)*y(3)*y(6);
dydt(4) = a(3)*y(3)*y(6)-a(3)*y(5)*y(4);
dydt(5) = 2*a(5)*a(1)*y(1)+a(3)*y(6)*y(3)-a(3)*y(5)*y(4)-a(6)*y(5)*(y(5)+y(6))-a(4)*y(5)*y(2);
dydt(6) = a(4)*y(2)*y(5)+a(3)*y(5)*y(4) - a(3)*y(3)*y(6) - a(6)*y(6)*(y(5)+y(6));
dydt(7) = 0.5*a(6)*(y(5)+y(6))*(y(5)+y(6));
dydt(8) = a(4)*y(2)*(y(5)+y(6)) +a(3)*y(10)*(y(5)+y(6))-a(3)*y(8)*(y(3)+y(4))-a(6)*y(8)*(y(5)+y(6));
dydt(9) = a(4)*y(2)*(y(5)+y(6)+2*y(8))+a(3)*y(11)*(y(5)+y(6))-a(3)*(y(3)+y(4))*y(9)-a(6)*(y(5)+y(6))*y(9);
dydt(10) = a(3)*(y(3)+y(4))*y(8)-a(3)*(y(5)+y(6))*y(10);
dydt(11) = a(3)*(y(3)+y(4))*y(9)-a(3)*(y(5)+y(6))*y(11);
dydt(12) = a(6)*y(8)*(y(5)+y(6));
dydt(13) = a(6)*y(9)*(y(5)+y(6))+a(6)*y(8)*y(8);

%=====================================================================================

 function [tspan,y0,options] = init(a,b,c,d)

 tspan = [0 5e6];    % default timespan
 nr = d;             % number of differential equations/compounds
 y0 = zeros(1,nr);   % starting concentrations
 y0(1:3) = b(1:3);
 options = odeset('AbsTol',1e-16,'RelTol',3e-14,'BDF','off','Stats','on','Events','on');
                     % error tolerances, Backw. Diff. Formulas 
 
%=====================================================================================
 
 function [value,isterminal,direction] = events(t,y,a,b,c,d)

 % first criterium
 % b(1)= concentration I at t=0,  b(2)= concentration M at t=0
 % y(1)= concentration I at t=t,  y(2)= concentration M at t=t
 % c(1)= maximum conversion of I, c(2)= maximum conversion of M
 % abort integration when one of both components reaches max. conversion

 % second criterium: integrating noise, [radicals]<0

 value = zeros(1,3);
 value(1) = ((b(1)-y(1))/b(1))-c(1); % max conversion=zero crossing
 value(2) = ((b(2)-y(2))/b(2))-c(2);
 value(3) = y(6);                    % Pi<0
 
 isterminal = zeros(1,3);    
 isterminal(1:3) = [0,1,1];          % all are terminal events

 direction = zeros(1,3);             % direction unimportant
 % ----------------------------------------------------------------------------------------
 
